#pragma once
#include "Config.h"
#include "ConfigSTY.h"

//////////////////////////////////////////////////////////////////////////////////////
#define kCfgEventEchoChange		1000
//////////////////////////////////////////////////////////////////////////////////////
// Constants for +CLCK
struct StructCLCK
{		
	CString fac;
	CString desc;
	int mode;
	CString passwd;
	int classx;
	int needClass;
	StructCLCK()
	{
	}
	StructCLCK(CString iFac, CString iDesc, int iNeedClass=1, int iClassx=0, int iMode=0, CString iPasswd="")
	{
		fac=iFac;
		desc=iDesc;
		mode=iMode;
		needClass=iNeedClass;
		passwd=iPasswd;
		classx=iClassx;
	}
};
//////////////////////////////////////////////////////////////////////////////////////
#define	kStyFacPin1Key					"FacPin"
#define	kStyFacPhoneToSimKey			"FacPhoneToSim"
#define	kStyFacPhoneToFirstSimKey		"FacPhoneToFirstSim"
#define	kStyDefaultFacState				0
// special trully vib mode
#define kTrullyVibKey					"TrullyVib"
#define kTrullyVibDefault				0
/*****************/
/* Facility Lock */
/*****************/
#define	kTelFacLockSC						"\"SC\""
#define	kTelFacLockPS						"\"PS\""
#define	kTelFacLockPF						"\"PF\""
#define	kTelFacLockFD						"\"FD\""
#define	kTelFacLockAOC						"\"AO\""	// Bar All Outgoing Calls 		
#define	kTelFacLockOIC						"\"OI\""	// Bar Outgoing International Calls 
#define	kTelFacLockOX						"\"OX\""	// Bar Outgoing International Calls except to Home Country 
#define	kTelFacLockAIC						"\"AI\""	// Bar All Incoming Calls 		
#define	kTelFacLockIR						"\"IR\""	// Bar Incoming Calls when Roaming outside the home country 
#define	kTelFacLockAll						"\"AB\""	// All Barring services 		
#define	kTelFacLockAllOutgoing				"\"AG\""	// All outgoing barring services 


#define	kTelFacLockAOCIndex					0
#define	kTelFacLockOICIndex 				1
#define	kTelFacLockOXIndex					2 
#define	kTelFacLockAICIndex					3
#define	kTelFacLockIRIndex					4
#define	kTelFacLockAllIndex					5 		
#define	kTelFacLockAllOutgoingIndex			6
#define	kFacLockMaxIndex					kTelFacLockIRIndex

#define	kTelFacLockSCIndex					7
#define	kTelFacLockPSIndex					8
#define	kTelFacLockPFIndex					9
#define	kTelFacLockFDIndex					10

/*******************/
/* Call Forwarding */
/*******************/
//These constants must represent indexes (0 based)
#define kCallClassVoice						0
#define kCallClassData						1 
#define kCallClassFax						2
#define kCallClassSms						3
#define kCallClassDataCircuitSync			4
#define kCallClassDataCircuitASync			5
#define kCallClassDedicatedPacketAccess		6
#define kCallClassDedicatedPADAccess		7
#define kCallClassMaxSupportedValue			kCallClassDedicatedPADAccess
#define kCallClassAll						8

#define kCallFwdReasonUnconditional			0
#define kCallFwdReasonMeBusy				1
#define kCallFwdReasonNoReply				2
#define kCallFwdReasonNotReachable			3
#define kCallFwdReasonAllCallForwarding		4
#define kCallFwdReasonAllConditionalCallFwd	5
#define kCallFwdMaxReasonIndex				kCallFwdReasonAllConditionalCallFwd
// Constants for +CMER
#define	kCfgMEEvtRepModeKey				"MEEvtRepMode"
#define	kCfgMEEvtRepKeypKey				"MEEvtRepKeyp"
#define	kCfgMEEvtRepDispKey				"MEEvtRepDisp"
#define	kCfgMEEvtRepIndKey				"MEEvtRepInd"
#define	kCfgMEEvtRepBfrKey				"MEEvtRepBfr"
#define	kCfgDefaultMEEvtRepMode			3
#define	kCfgDefaultMEEvtRep				0
// Constants for +CIND
enum eIND{
	eIndCBatteryChargeLvl = 0,
	eIndCSignalQuality,
	eIndCMessageReceived,
	eIndCRoamingInd,
	eIndCSmsStorageFull,
	eIndCStandardIndicatorEnd,
	eIndCPhonebookReady,
	eIndCSmsReady,
	eIndCStkReady,
	eLastIndExpected
};

struct StructIND
{		
	int ind;
	CString descr;
	Bool writable;
	Bool sent;
	StructIND()
	{
	}
	StructIND(CString iDescr, Bool iWritable=FALSE, int iInd=0, Bool iSent=FALSE)
	{
		ind=iInd;
		descr=iDescr;
		writable=iWritable;
	}
};
//////////////////////////////////////////////////////////////////////////////////////
#define kCfgMEIndCBatteryChargeLvlKey	"MEIndCBatteryChargeLvl"
#define	kCfgMEIndCSignalQualityKey		"MEIndCSignalQuality" 
#define	kCfgMEIndCMsgReceivedKey		"MEIndCMsgReceived"
#define	kCfgMEIndCRoamingIndKey			"MEIndCRoamingInd"
#define	kCfgMEIndCSmsStorageFullKey		"MEIndCSmsStorageFull"
#define	kCfgMEIndCPhonebookReadyKey		"MEIndCPhonebookReady"
#define	kCfgMEIndCSmsReadyKey			"MEIndCSmsReady"
#define	kCfgMEIndCStkReadyKey			"MEIndCStkReady"
#define	kCfgDefaultMEIndC				0
// Constants for +CVIB
#define	kCfgMEVibratorModeKey			"MEVibratorMode"
// Constants for +CALM
#define	kCfgMEAlertSoundModeKey			"MEAlertSoundMode"
// Constants for +CRSL
#define	kCfgMERingerSoundLevelKey		"MERingerSoundLevel"
// Constants for +CNUM
#define	kCfgPhoneNumberKey				"PhNum"
#define kCfgDefaultPhoneNumber			"+336558986"
// Constants for +CSCS
#define kCfgTECharsetKey				"CharSet"
#define kCfgTEDefaultCharset			"GSM"
// Constants for +CGMI
#define	kInfBrandKey					"Brand"
#define	kDefaultBrand					"PalmSource"
// Constants for +CGMM
#define	kInfModelKey					"Virtual Phone"
#define kDefaultModel					"3210"
// Constants for +CGMR
#define	kInfRevisionKey					"Rev"
#define kDefaultRevision				"2.0"
// Constants for +CGSN
#define	kInfSerialNumKey				"SerNum"
#define kDefaultSerialNum				"5465468745"
// Constants for +CMEE
#define kRMEErrorKey					"RMEError"
#define kDefaultRMEError				0
// Constants for +CLVL
#define	kSndLSpeakerLvlKey			"LSpkLvl"
#define	kSndDefaultLSpeakerLvl		1
// E0E1
#define	kDefaultEcho				0
#define kEchoKey					"Echo"
// X
#define	kDefaultX					0
#define kXKey						"X"
// Other
#define	kSpcEmcNumberKey			"EmcNum"
#define	kDefaultEmcNum				"112"
// Constants for +CMUT
#define kSndMuteKey					"Mute"
#define kSndMuteDefault				0

//////////////////////////////////////////////////////////////////////////////////////
#ifdef DLLMANAGER_EXPORTS
	#define DLLMANAGER_API __declspec(dllexport)
#else
	#define DLLMANAGER_API __declspec(dllimport)
#endif
//////////////////////////////////////////////////////////////////////////////////////
class DLLMANAGER_API CConfigCFG : public CConfig
{
private:
	CString mEmcNumber;	
	// +CLCK
	int mFacPin;
	int mFacPhoneToSim;
	int mFacPhoneToFirstSim;	
	int mDefaultMode;
	CString mDefaultPasswd;
	int mDefaultClassx;
	// mCLassxList use to dynamicaly fill comboboxes in associated ConfigUI
	CList<StructIntParam*,StructIntParam*> mClassxList;
	CList<StructCLCK*,StructCLCK*> mCLCKList;	
	// +CMER
	int	mMEEvtRepMode;
	int	mMEEvtRepKeyp;
	int	mMEEvtRepDisp;
	int	mMEEvtRepInd;
	int	mMEEvtRepBfr;
	// +CIND
	int	mMEIndControl[eLastIndExpected];
	CList<StructIND*,StructIND*> mINDList;	
	// +CVIB
	int	mMEVibratorMode;
	// +CALM
	int	mMEAlertSoundMode;
	// +CRSL
	int	mMERingerSoundLevel;
	// +CNUM
	CString mPhoneNumber;	
	// +CSCS
	CString mCharSet;
	// +CGMI
	CString mBrand; 
	// +CGMM
	CString mModel;
	// +CGMR
	CString mRevision;
	// +CGSN
	CString mSerialNum;
	// +CMEE
	int mRMEError;
	// +CLVL
	int mSpeakerLevel;
	// sprecial mode for windows vibration on ring
	int mTrullyVib;
	// E0E1
	int mEcho;
	// cmd X
	int mX;
	// +CMUT
	int mMute;

protected:
	DECLARE_SERIAL(CConfigCFG);
public:
	CConfigCFG() {};
	CConfigCFG(CDllManager* iDllManager);
	virtual ~CConfigCFG(void);
	// CConfig Interface Functions	
	virtual Bool Load();
	virtual Bool Save();	
	// GET
	virtual CString GetEmcNumber();
	virtual int GetTrullyVib();
	// GET +CLCK
	virtual CList<StructCLCK*,StructCLCK*>* GetFacList();
	virtual StructCLCK* GetFac(CString iFac);
	virtual CString GetSupportedFac();
	virtual int GetFacPin();
	virtual int GetFacPhoneToSim();
	virtual int GetFacPhoneToFirstSim();
	// GET +CMER
	virtual int	GetMEEvtRepMode();
	virtual int	GetMEEvtRepKeyp();
	virtual int	GetMEEvtRepDisp();
	virtual int	GetMEEvtRepInd();
	virtual int	GetMEEvtRepBfr();
	// GET +CIND
	//virtual int GetIND(int iIND);
	virtual StructIND* GetIND(CString iDescr);
	virtual int GetINDPos(CString iINDDescr);
	// GET +CVIB
	virtual int GetMEVibratorMode();
	// GET +CALM
	virtual int GetMEAlertSoundMode();
	// GET +CRSL
	virtual int GetMERingerSoundLevel();
	// GET +CNUM
	virtual CString GetPhoneNumber();
	// GET +CSCS
	virtual CString GetCharSet();
	// GET +CGMI
	virtual CString GetBrand();
	// GET +CGMM
	virtual CString GetModel();
	// GET +CGMR
	virtual CString GetRevision();
	// GET +CGSN
	virtual CString GetSerialNum();
	// GET +CMEE
	virtual int GetRMEError();
	// GET +CLVL
	virtual int GetSpeakerLevel();
	// GET E0V1
	virtual int GetEcho();
	// GET X
	virtual int GetX();
	// GET MUTE
	virtual int GetMute() {return mMute;};
	virtual CString GetCNum();

	// SET
	virtual void SetEmcNumber(CString iEmc);
	virtual void SetTrullyVib(int iVib);
	// SET +CLCK
	virtual void SetFac(CString iFac, int iMode, CString iPasswd, int iClassx);	
	virtual void SetFacPin(int iFacPin);
	virtual void SetFacPhoneToSim(int iFacPhoneToSim);
	virtual void SetFacPhoneToFirstSim(int iFacPhoneToFirstSim);	
	// SET +CMER
	virtual void SetMEEvtRepMode(int iMEEvtRepMode);
	virtual void SetMEEvtRepKeyp(int iMEEvtRepKeyp);
	virtual void SetMEEvtRepDisp(int iMEEvtRepDisp);
	virtual void SetMEEvtRepInd(int iMEEvtRepInd);
	virtual void SetMEEvtRepBfr(int iMEEvtRepBfr);
	// SET +CIND
	//virtual void SetIND(int iIND, int iValue);
	virtual int SetIND(CString iDescr, int iValue, Bool iForced=0);
	// SET +CVIB
	virtual void SetMEVibratorMode(int iMEVibratorMode);
	// SET +CALM
	virtual void SetMEAlertSoundMode(int iMEAlertSoundMode);
	// SET +CRSL
	virtual void SetMERingerSoundLevel(int iMERingerSoundLevel);
	// SET +CNUM
	virtual void SetPhoneNumber(CString iPhoneNumber);
	// SET +CSCS
	virtual void SetCharSet(CString iCharSet);
	// SET +CGMI
	virtual void SetBrand(CString iBrand);
	// SET +CGMM
	virtual void SetModel(CString iModel);
	// SET +CGMR
	virtual void SetRevision(CString iRevision);
	// SET +CGSN
	virtual void SetSerialNum(CString iSerialNum);
	// SET +CMEE
	virtual void SetRMEError(int iType);
	// SET +CLVL
	virtual void SetSpeakerLevel(int iSpeakerLevel);
	// SET E0E1
	virtual void SetEcho(int iWantEcho);
	// SET X
	virtual void SetX(int iValue);
	// SET MUTE
	virtual void SetMute(int iValue);

	// OTHER
	// Add an indicator control to the config
	virtual void AddIND(StructIND* iStructIND); 
	// Remove the indicator list
	virtual void RemoveIND();
	// Fill indicator list from parameter list
	virtual void FillIND(CList<StructParam,StructParam&>* iParamList);
	// Since SC and FD fac are PIN1 and PIN2 code dependent, provide function to get them
	virtual CString GetPINCode(EStyState iState);
};
